#include "ConfigurationServer.h"
#include "ConfigFile.h"
#include <iostream>
namespace Configuration
{

ConfigurationServer* ConfigurationServer::instance = 0;

ConfigurationServer::ConfigurationServer()
{
	communicationreceiverport = 34465;
	simulationengineport = 44337;
	simulationengineip = "127.0.0.1";
	communicationreceiverip = "127.0.0.1";
	maximumdatagramsize = 40000;
	defaulthardnessinteraction = 0.15;
	defaultbouncinessinteraction = 0.6;
	defaultslip1interaction = 0.1;
	defaultslip2interaction = 0.1;
	defaultfrictioninteraction = 1.0;
	defaultgravity = -0.5;
	contactpointsammount = 10;
	defaultresponserequest = false;
	defaultwheeljointhardness = 0.001;
	defaultwheeljointbounciness = 0.9;
	defaultwheeljointmaxtorque = 10;
	defaultbodymaterial = 0;
	defaultbodymass = -1;
	commandcreateentitykey = "Create_Entity";
	commandrobotcontrolkey = "Robot_Motor_Control";
	commandinitializesimulationkey = "Initialize_Simulation";
	commandsettimestepkey = "Set_Timestep";
	commandsetstepmodekey = "Set_Step_Mode";
	commandsetstepflagkey = "Make_Step";
	commandsynchronizekey = "Synchronize";
	commandsetsyncmodekey = "Set_Sync_Mode";
	commandsetsyncwaitkey = "Set_Sync_Wait";
	commandsetworldgravitykey = "Set_World_Gravity";
	commandsetworldbouncinesskey = "Set_World_Bounciness";
	commandsetworldhardnesskey = "Set_World_Hardness";
	commandsetentitypositionkey = "Set_Entity_Position";
	commandregistermaterialsinteractionskey = "Register_Materials_Interactions";
	commandsavetofilekey = "Save"; 
	commandloadfromfilekey = "Load";
	commandsetfastmodekey = "Set_Fast_Mode";
	commandstepsperiterationskey = "Set_Steps_Per_Iteration";
	commandsetautoadjustmodekey = "Set_AutoAdjust_Mode"; 
	defaultstepsize = 0.03;
	syncwait = 0.8;
	defaultphysicsworldbounciness = 0.2;
	defaultphysicsworldhardness = 1e-10;
	/*
	char *buffer;
	FILE *file;
	file=fopen("../Configuration/Configuration.data","r");
	fseek(file,0,SEEK_END); //go to end
	int len=ftell(file); //get position at end
	fseek(file,0,SEEK_SET); //go to beginning
	buffer=(char *)malloc(len); //malloc buffer
	fread(buffer,len,1,file); //read into buffer
	fclose(file);
	
	*/
	char bufpath[512];
	getcwd(bufpath, 512);
	strcat(bufpath, "/Configuration.data");
	ConfigFile config(bufpath);
	if (!config.readInto(communicationreceiverport,"communicationreceiverport"))
	{
		communicationreceiverport = 34465;
	}
	else
	{
		//cout<<"Anduvo "<< communicationreceiverport<< endl;
	}
	if (!config.readInto(simulationengineport,"simulationengineport"))
	{
		simulationengineport = 44337;
	}
	else
	{
		//cout<<"Anduvo "<< simulationengineport<< endl;
	}	
	if (!config.readInto(simulationengineip,"simulationengineip"))
	{
		simulationengineip = "127.0.0.1";
	}
	else
	{
		//cout<<"Anduvo "<< simulationengineip<< endl;
	}

	if (!config.readInto(communicationreceiverip,"communicationreceiverip"))
	{
		communicationreceiverip = "127.0.0.1";
	}
	else
	{
		//cout<<"Anduvo "<< communicationreceiverip<< endl;
	}
	if (!config.readInto(maximumdatagramsize,"maximumdatagramsize"))
	{
		maximumdatagramsize = 40000;
	}
	else
	{
		//cout<<"Anduvo "<< maximumdatagramsize<< endl;
	}
	if (!config.readInto(defaulthardnessinteraction,"defaulthardnessinteraction"))
	{
		defaulthardnessinteraction = 0.15;
	}
	else
	{
		//cout<<"Anduvo "<< defaulthardnessinteraction<< endl;
	}
	if (!config.readInto(defaultbouncinessinteraction,"defaultbouncinessinteraction"))
	{
		defaultbouncinessinteraction = 0.6;
	}
	else
	{
		//cout<<"Anduvo "<< defaultbouncinessinteraction<< endl;
	}
	if (!config.readInto(defaultslip1interaction,"defaultslip1interaction"))
	{
		defaultslip1interaction = 0.1;
	}
	else
	{
		//cout<<"Anduvo "<< defaultslip1interaction<< endl;
	}
	if (!config.readInto(defaultslip2interaction,"defaultslip2interaction"))
	{
		defaultslip2interaction = 0.1;
	}
	else
	{
		//cout<<"Anduvo "<< defaultslip2interaction<< endl;
	}
	if (!config.readInto(defaultfrictioninteraction,"defaultfrictioninteraction"))
	{
		defaultfrictioninteraction = 1.0;
	}
	else
	{
		//cout<<"Anduvo "<< defaultfrictioninteraction<< endl;
	}
	if (!config.readInto(defaultgravity,"defaultgravity"))
	{
		defaultgravity = -0.5;
	}
	else
	{
		//cout<<"Anduvo "<< defaultgravity<< endl;
	}
	if (!config.readInto(contactpointsammount,"contactpointsammount"))
	{
		contactpointsammount = 10;
	}
	else
	{
		//cout<<"Anduvo "<< contactpointsammount<< endl;
	}
	if (!config.readInto(defaultresponserequest,"defaultresponserequest"))
	{
		defaultresponserequest = false;
	}
	else
	{
		//cout<<"Anduvo "<< defaultresponserequest<< endl;
	}
	if (!config.readInto(defaultwheeljointhardness,"defaultwheeljointhardness"))
	{
		defaultwheeljointhardness = 0.001;
	}
	else
	{
		//cout<<"Anduvo "<< defaultwheeljointhardness<< endl;
	}
	if (!config.readInto(defaultwheeljointbounciness,"defaultwheeljointbounciness"))
	{
		defaultwheeljointbounciness = 0.9;
	}
	else
	{
		//cout<<"Anduvo "<< defaultwheeljointbounciness<< endl;
	}
	if (!config.readInto(defaultwheeljointmaxtorque,"defaultwheeljointmaxtorque"))
	{
		defaultwheeljointmaxtorque = 10;
	}
	else
	{
		//cout<<"Anduvo "<< defaultwheeljointmaxtorque<< endl;
	}
	if (!config.readInto(defaultbodymaterial,"defaultbodymaterial"))
	{
		defaultbodymaterial = 0;
	}
	else
	{
		//cout<<"Anduvo "<< defaultbodymaterial<< endl;
	}
	if (!config.readInto(defaultbodymass,"defaultbodymass"))
	{
		defaultbodymass = -1;
	}
	else
	{
		//cout<<"Anduvo "<< defaultbodymass<< endl;
	}
	if (!config.readInto(commandcreateentitykey,"commandcreateentitykey"))
	{
		commandcreateentitykey = "Create_Entity";
	}
	else
	{
		//cout<<"Anduvo "<< commandcreateentitykey<< endl;
	}
	if (!config.readInto(commandrobotcontrolkey,"commandrobotcontrolkey"))
	{
		commandrobotcontrolkey = "Robot_Motor_Control";
	}
	else
	{
		//cout<<"Anduvo "<< commandrobotcontrolkey<< endl;
	}
	if (!config.readInto(commandinitializesimulationkey,"commandinitializesimulationkey"))
	{
		commandinitializesimulationkey = "Initialize_Simulation";
	}
	else
	{
		//cout<<"Anduvo "<< commandinitializesimulationkey<< endl;
	}
	if (!config.readInto(commandsettimestepkey,"commandsettimestepkey"))
	{
		commandsettimestepkey = "Set_Timestep";
	}
	else
	{
		//cout<<"Anduvo "<< commandsettimestepkey<< endl;
	}
	if (!config.readInto(commandsetstepmodekey,"commandsetstepmodekey"))
	{
		commandsetstepmodekey = "Set_Step_Mode";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetstepmodekey<< endl;
	}
	if (!config.readInto(commandsetstepflagkey,"commandsetstepflagkey"))
	{
		commandsetstepflagkey = "Make_Step";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetstepflagkey<< endl;
	}
	if (!config.readInto(commandsynchronizekey,"commandsynchronizekey"))
	{
		commandsynchronizekey = "Synchronize";
	}
	else
	{
		//cout<<"Anduvo "<< commandsynchronizekey<< endl;
	}
	if (!config.readInto(commandsetsyncmodekey,"commandsetsyncmodekey"))
	{
		commandsetsyncmodekey = "Set_Sync_Mode";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetsyncmodekey<< endl;
	}
	if (!config.readInto(commandsetsyncwaitkey,"commandsetsyncwaitkey"))
	{
		commandsetsyncwaitkey = "Set_Sync_Wait";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetsyncwaitkey<< endl;
	}
	if (!config.readInto(commandsetworldgravitykey,"commandsetworldgravitykey"))
	{
		commandsetworldgravitykey = "Set_World_Gravity";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetworldgravitykey<< endl;
	}
	if (!config.readInto(commandsetworldbouncinesskey,"commandsetworldbouncinesskey"))
	{
		commandsetworldbouncinesskey = "Set_World_Bounciness";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetworldbouncinesskey<< endl;
	}
	if (!config.readInto(commandsetworldhardnesskey,"commandsetworldhardnesskey"))
	{
		commandsetworldhardnesskey = "Set_World_Hardness";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetworldhardnesskey<< endl;
	}
	if (!config.readInto(commandsetentitypositionkey,"commandsetentitypositionkey"))
	{
		commandsetentitypositionkey = "Set_Entity_Position";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetentitypositionkey<< endl;
	}
	if (!config.readInto(commandregistermaterialsinteractionskey,"commandregistermaterialsinteractionskey"))
	{
		commandregistermaterialsinteractionskey = "Register_Materials_Interactions";
	}
	else
	{
		//cout<<"Anduvo "<< commandregistermaterialsinteractionskey<< endl;
	}
	if (!config.readInto(commandsavetofilekey,"commandsavetofilekey"))
	{
		commandsavetofilekey = "Save";
	}
	else
	{
		//cout<<"Anduvo "<< commandsavetofilekey<< endl;
	}
	if (!config.readInto(commandloadfromfilekey,"commandloadfromfilekey"))
	{
		commandloadfromfilekey = "Load";
	}
	else
	{
		//cout<<"Anduvo "<< commandloadfromfilekey<< endl;
	}
	if (!config.readInto(commandstepsperiterationskey,"commandstepsperiterationskey"))
	{
		commandstepsperiterationskey = "Set_Steps_Per_Iteration";
	}
	else
	{
		//cout<<"Anduvo "<< commandstepsperiterationskey<< endl;
	}
	if (!config.readInto(commandsetfastmodekey,"commandsetfastmodekey"))
	{
		commandsetfastmodekey = "Set_Fast_Mode";
	}
	else
	{
		//cout<<"Anduvo "<< commandsetfastmodekey<< endl;
	}
	

	if (!config.readInto(defaultstepsize,"defaultstepsize"))
	{
		defaultstepsize = 0.03;
	}
	else
	{
		//cout<<"Anduvo "<< defaultstepsize<< endl;
	}
	if (!config.readInto(syncwait,"syncwait"))
	{
		syncwait = 0.8;
	}
	else
	{
		//cout<<"Anduvo "<< syncwait<< endl;
	}
	if (!config.readInto(defaultphysicsworldbounciness,"defaultphysicsworldbounciness"))
	{
		defaultphysicsworldbounciness = 0.2;
	}
	else
	{
		//cout<<"Anduvo "<< defaultphysicsworldbounciness<< endl;
	}
	if (!config.readInto(defaultphysicsworldhardness,"defaultphysicsworldhardness"))
	{
		defaultphysicsworldhardness = 1e-10;
	}
	else
	{
		//cout<<"Anduvo "<< defaultphysicsworldhardness<< endl;
	}
	
	
}

ConfigurationServer *ConfigurationServer::GetInstance()
{
	if (instance==0)
			instance =  new ConfigurationServer();
	return instance;
}

string ConfigurationServer::GetSimulationEngineKey()
{
	return simulationenginekey;
}

int ConfigurationServer::GetCommunicationReceiverPort()
{	
	return communicationreceiverport;
}

int ConfigurationServer::GetSimulationEnginePort()
{	
	return simulationengineport;
}

string ConfigurationServer::GetSimulationEngineIP()
{	
	return simulationengineip;
}

string ConfigurationServer::GetCommunicationReceiverIP()
{	
	return communicationreceiverip;
}

int ConfigurationServer::GetMaximumDatagramSize()
{	
	return maximumdatagramsize;
}

float ConfigurationServer::GetDefaultHardnessInteraction()
{	
	return defaulthardnessinteraction;
}

float ConfigurationServer::GetDefaultBouncinessInteraction()
{	
	return defaultbouncinessinteraction;
}

float ConfigurationServer::GetDefaultSlip1Interaction()
{	
	return defaultslip1interaction;
}
float ConfigurationServer::GetDefaultSlip2Interaction()
{
	return defaultslip2interaction;
}

float ConfigurationServer::GetDefaultFrictionInteraction()
{	
	return defaultfrictioninteraction;
}

float ConfigurationServer::GetDefaultGravity()
{
	return defaultgravity;
}

int ConfigurationServer::GetContactPointsAmmount()
{
	return contactpointsammount;
}

string ConfigurationServer::GetCommandCreateEntityKey()
{	
	return commandcreateentitykey;
}

bool ConfigurationServer::GetDefaultResponseRequest()
{	
	return defaultresponserequest;
}

float ConfigurationServer::GetDefaultWheelJointHardness()
{	
	return defaultwheeljointhardness;
}
	
float ConfigurationServer::GetDefaultWheelJointBounciness()
{	
	return defaultwheeljointbounciness;
}

float ConfigurationServer::GetDefaultWheelJointMaxTorque()
{
	return defaultwheeljointmaxtorque;
}

int ConfigurationServer::GetDefaultBodyMaterial()
{
	return defaultbodymaterial;
}

float ConfigurationServer::GetDefaultBodyMass()
{
	return defaultbodymass;
}

string ConfigurationServer::GetCommandRobotControlKey()
{
	return commandrobotcontrolkey;
}

float ConfigurationServer::GetDefaultPhysicsWorldHardness()
{
	return defaultphysicsworldhardness;
}

float ConfigurationServer::GetDefaultPhysicsWorldBounciness()
{
	return defaultphysicsworldbounciness;
}

string ConfigurationServer::GetCommandInitializeSimulationKey()
{
	return commandinitializesimulationkey;
}

string ConfigurationServer::GetCommandSetTimeStepKey()
{
	return commandsettimestepkey;
}

string ConfigurationServer::GetCommandSetStepModeKey()
{
	return commandsetstepmodekey;
}

string ConfigurationServer::GetCommandSetStepFlagKey()
{
	return commandsetstepflagkey;
}

string ConfigurationServer::GetCommandSynchronizeKey()
{
	return commandsynchronizekey;
}

string ConfigurationServer::GetCommandSetSyncModeKey()
{
	return commandsetsyncmodekey;
}

string ConfigurationServer::GetCommandSetSyncWaitKey()
{
	return commandsetsyncwaitkey;
}

string ConfigurationServer::GetCommandRegisterMaterialsInteractionsKey()
{
	return commandregistermaterialsinteractionskey;
}

float ConfigurationServer::GetDefaultStepSize()
{
	return defaultstepsize;
}

double ConfigurationServer::GetSyncWait()
{
	return syncwait;
}

string ConfigurationServer::GetCommandSetWorldGravityKey()
{
	return commandsetworldgravitykey;
}

string ConfigurationServer::GetCommandSetWorldBouncinessKey()
{
	return commandsetworldbouncinesskey;
}

string ConfigurationServer::GetCommandSetEntityPositionKey()
{
	return commandsetentitypositionkey;
}

string ConfigurationServer::GetCommandSetWorldHardnessKey()
{
	return commandsetworldhardnesskey;
}

string ConfigurationServer::GetCommandSaveToFileKey()
{
	return commandsavetofilekey;
}

string ConfigurationServer::GetCommandLoadFromFileKey()
{
	return commandloadfromfilekey;
}

string ConfigurationServer::GetCommandStepsPerIterationKey()
{
	return commandstepsperiterationskey;
}

string ConfigurationServer::GetCommandSetFastModeKey()
{
	return commandsetfastmodekey;
}

string ConfigurationServer::GetCommandSetAutoAdjustModeKey()
{
	return commandsetautoadjustmodekey;
}

}
